<?php
/*
	■コール方法
	include_once( "../../raijyo/inc/session_handler.php" );

	session_cache_limiter( 'public' );  // (1) キャッシュを完全に無効にしたい時
	session_cache_limiter( 'private' ); // (2) 「javascript:history.back();」のBackボタンを有効にしたい時
	(1)と(2)は必要な時にどちらか片方だけ使う。

	※セッションIDを明示的に指定したい時は)下記の3行を追加する。
	if( strlen( $over_sesid ) > 0 ) {
		session_id( $over_sesid );
	}

	session_start();

	$sesid = session_id();

CREATE TABLE `pb_session_tbl` (
  `sesid` varchar(100) NOT NULL,
  `sesval` text,
  `lastupday` datetime NOT NULL,
  PRIMARY KEY  (`sesid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
*/
class Session_Control {
	private static $_sess_con;
	private static $_sess_name;

	public static function open( $save_path, $session_name ) {
		self::$_sess_name = $session_name;

		// if( self::$_sess_con = new mysqli( 'hostname', 'user', 'password', 'database', 'port', 'socket' ) ) {
		if( self::$_sess_con = new mysqli( '127.0.0.1', 'chz1175004', '5Hxm8iuR', 'chz1175004_common', '3307', '' ) ) {
		//if( self::$_sess_con = new mysqli( '183.90.241.211', 'ykb2_formus', 'Ms5t8Q4p', 'ykb2_form', '3306' ) ) {

			self::$_sess_con->set_charset( 'utf8' );

			return true;
		}

		return false;
	}

	public static function close() { return self::$_sess_con->close(); }

	public static function read( $id ) {
		$r = self::$_sess_con->query( "SELECT sesval FROM pb_session_tbl WHERE sesid = '".addslashes( $id )."'" );

		if( $r->num_rows == 0 ) return '';
		$n = $r->fetch_assoc();

		return $n['sesval'];
	}

	public static function write( $id, $data ) {
		return self::$_sess_con->query( "REPLACE INTO pb_session_tbl ( sesid, sesval, lastupday ) VALUES ('".addslashes( $id )."','".addslashes( $data )."',NOW())" );
	}

	public static function destroy( $id ) {
		return self::$_sess_con->query( "DELETE FROM pb_session_tbl WHERE sesid = '".addslashes( $id )."'" );
	}

	public static function gc( $max ) {
/*
		■セッションIDを使って他のテーブルのレコードを削除したい時は下記の4行をコメントアウトする。
		$gc_tlb = array( 'pb_tmp_xxx_tbl' );
		foreach( $gc_tlb as $tbl ) {
			self::$_sess_con->query( "DELETE FROM {$tbl} WHERE sesid IN ( SELECT sesid FROM pb_session_tbl WHERE lastupday < NOW() - INTERVAL 5 HOUR )" );
		}
*/
		self::$_sess_con->query( "DELETE FROM pb_session_tbl WHERE lastupday < NOW() - INTERVAL 5 HOUR" );

		return true;
	}
}

register_shutdown_function( 'session_write_close' ); // mysqli使用時「close」が効かないため必要(mysqliのバグ)
session_set_save_handler(
	array( 'Session_Control', 'open' ),
	array( 'Session_Control', 'close' ),
	array( 'Session_Control', 'read' ),
	array( 'Session_Control', 'write' ),
	array( 'Session_Control', 'destroy' ),
	array( 'Session_Control', 'gc' )
);
?>
